<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$form->setFormTagAttribute('onsubmit', 'setupTag(this); return(false);');

$form->setFormTagAttribute('class', 'web_form');
$form->developerTags['colClassPrefix'] = 'col-md-';
$form->developerTags['fld_default_col'] = 6;

$autoUpdateFld = $form->getField('auto_update_other_langs_data');
if(null != $autoUpdateFld) {
	$autoUpdateFld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');
	$autoUpdateFld->developerTags['cbHtmlAfterCheckbox'] = '<i class="input-helper"></i>';
}
?>

<section class="section">
	<div class="sectionhead">
		<h4><?php echo Labels::getLabel('LBL_Tag_Setup',$adminLangId); ?></h4>
	</div>
	<div class="sectionbody space">
		<div class="row">		
			<div class="col-sm-12">
				<?php echo $form->getFormTag(); ?>

					<?php $divLayout = Language::getLayoutDirection($siteDefaultLangId); ?>
					<div class="" dir="<?php echo $divLayout; ?>">
						<div class="row">
							<div class="col-md-6">
								<div class="field-set">
									<div class="caption-wraper">
										<label class="field_label">
											<?php
											$fld = $form->getField('tag_name[' . $siteDefaultLangId . ']');
											echo $fld->getCaption();
											?>
										</label>
										<span class="spn_must_field">*</span>
									</div>
									<div class="field-wraper">
										<div class="field_cover">
											<?php echo $form->getFieldHtml('tag_name[' . $siteDefaultLangId . ']'); ?>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-md-6">
								<div class="field-set">
									<div class="caption-wraper">
										<label class="field_label">
											<?php
											$fld = $form->getField('tag_type');
											echo $fld->getCaption();
											?>
										</label>
										<span class="spn_must_field">*</span>
									</div>
									<div class="field-wraper">
										<div class="field_cover">
											<?php echo $form->getFieldHtml('tag_type'); ?>
										</div>
									</div>
								</div>
							</div>
						</div>
							
						<?php
						$translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
						if (!empty($translatorSubscriptionKey) && count($otherLanguages) > 0) {
							?>
							<div class="row">
								<div class="col-md-12">
									<div class="field-set mb-0">
										<div class="caption-wraper"></div>
										<div class="field-wraper">
											<div class="field_cover">
												<?php echo $form->getFieldHtml('auto_update_other_langs_data'); ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
					</div>            

					<?php
					if (!empty($otherLanguages)) {
						foreach ($otherLanguages as $langId => $data) {
							$layout = Language::getLayoutDirection($langId);
							?>
							<div class="accordion my-4 col-md-6 mb-4" id="specification-accordion-<?php echo $langId; ?>">
								<h6 class="dropdown-toggle" data-toggle="collapse" data-target="#collapse-<?php echo $langId; ?>" aria-expanded="true" aria-controls="collapse-<?php echo $langId; ?>"><span>
										<?php echo $data . " " . Labels::getLabel('LBL_Language_Data', $adminLangId); ?>
									</span>
								</h6>
								<div id="collapse-<?php echo $langId; ?>" class="collapse collapse-js-<?php echo $langId; ?>" aria-labelledby="headingOne" data-parent="#specification-accordion-<?php echo $langId; ?>">
									<div class="p-4 mb-4 bg-gray rounded" dir="<?php echo $layout; ?>">
										<div class="row">
											<div class="col-md-12">
												<div class="field-set">
													<div class="caption-wraper">
														<label class="field_label">
															<?php
															$fld = $form->getField('tag_name[' . $langId . ']');
															echo $fld->getCaption();
															?>
														</label>
													</div>
													<div class="field-wraper">
														<div class="field_cover">
															<?php echo $form->getFieldHtml('tag_name[' . $langId . ']'); ?>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<?php
						}
					}
					?>

					<div class="row">
						<div class="col-6">
							<div class="field-set">
								<!--<div class="caption-wraper"><label class="field_label"></label></div>-->
								<div class="field-wraper">
									<div class="field_cover">
										<?php
										echo $form->getFieldHtml('tag_id');
										echo $form->getFieldHtml('btn_submit');
										?>
									</div>
								</div>
							</div>
						</div>
					</div>
					</form>
					<?php echo $form->getExternalJS(); ?>
			</div>
		</div>
	</div>
</section>