<?php
$selected_method = '';
if ($order['order_pmethod_id']) {
    $selected_method .= CommonHelper::displayNotApplicable($adminLangId, $order["pmethod_name"]);
}
if ($order['order_is_wallet_selected'] == AppConstants::YES) {
    $selected_method .= ($selected_method != '') ? ' + ' . Labels::getLabel("LBL_Wallet", $adminLangId) : Labels::getLabel("LBL_Wallet", $adminLangId);
}
if ($order['order_reward_point_used'] > 0) {
    $selected_method .= ($selected_method != '') ? ' + ' . Labels::getLabel("LBL_Rewards", $adminLangId) : Labels::getLabel("LBL_Rewards", $adminLangId);
}
$imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
?>
<div class="page">
    <div class="container container-fluid">
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <?php if (!$print) { ?>
                    <div class="page__title no-print">
                        <div class="row">
                            <div class="col--first col-lg-6">
                                <span class="page__icon"><i class="ion-android-star"></i></span>
                                <h5><?php echo Labels::getLabel('LBL_Orders_Details', $adminLangId); ?></h5> <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <section class="section">
                    <div class="sectionhead">
                        <h4><?php echo Labels::getLabel('LBL_Seller_Order_Details', $adminLangId); ?></h4>
                        <?php
                        if (!$print) {
                            $data = [
                                'adminLangId' => $adminLangId,
                                'statusButtons' => false,
                                'deleteButton' => false,
                                'otherButtons' => [
                                    [
                                        'attr' => [
                                            'href' => CommonHelper::generateUrl('SellerOrders'),
                                            'title' => Labels::getLabel('LBL_BACK', $adminLangId)
                                        ],
                                        'label' => '<i class="fas fa-arrow-left"></i>'
                                    ],
                                ]
                            ];

                            $data['otherButtons'][] = [
                                'attr' => [
                                    'href' => Fatutility::generateUrl('sellerOrders', 'view', $urlParts) . '/print',
                                    'title' => Labels::getLabel('LBL_Print', $adminLangId)
                                ],
                                'label' => '<i class="fas fa-print"></i>'
                            ];

                            $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        }
                        ?>
                    </div>
                    <div class="sectionbody">
                        <table class="table table--details">
                            <tr>
                                <td><strong><?php echo Labels::getLabel('LBL_Invoice_Id', $adminLangId); ?>:</strong><?php echo $order["op_invoice_number"] ?></td>
                                <td><strong><?php echo Labels::getLabel('LBL_Order_Date', $adminLangId); ?>: </strong><?php echo FatDate::format($order["order_date_added"], true) ?></td>
                                <td><strong><?php echo Labels::getLabel('LBL_Status', $adminLangId); ?>:</strong> <?php echo $order["orderstatus_name"] ?></td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>
                                        <?php
                                        if ($order["op_refund_qty"] > 0) {
                                            echo Labels::getLabel('LBL_Refund_for_Qty.', $adminLangId);
                                        ?> [<?php echo $order["op_refund_qty"] ?>] :
                                    </strong><?php
                                                echo CommonHelper::displayMoneyFormat($order["op_refund_amount"], true, true);
                                            }
                                                ?>
                                </td>
                                <td>
                                    <strong><?php echo Labels::getLabel('LBL_Customer/Guest', $adminLangId); ?>: </strong><?php echo $order["buyer_user_name"] . ' (' . $order['buyer_username'] . ')'; ?>
                                    <?php if ($order["buyer_is_founding_member"] == AppConstants::YES) { ?>
                                        <ul class="tag-img">
                                            <li class="founding-icon">
                                                <i class="icn">
                                                    <i class="fas fa-user"></i>
                                                </i><?php echo Labels::getLabel('LBL_Founding_Member', $adminLangId); ?>
                                            </li>
                                        </ul>
                                    <?php } ?>
                                </td>
                                <td><strong><?php echo Labels::getLabel('LBL_Payment_Method', $adminLangId); ?>:</strong> <?php echo $selected_method; ?> </td>
                            </tr>
                            <tr>
                                <td><strong><?php echo Labels::getLabel('LBL_Commission_Charged', $adminLangId); ?>[<?php echo $order["op_commission_percentage"] ?>%]:
                                    </strong><?php echo CommonHelper::displayMoneyFormat($order['op_commission_charged'] - $order['op_refund_commission'], true, true); ?> </td>
                                <td><strong><?php echo Labels::getLabel('LBL_Cart_Total', $adminLangId); ?>:</strong><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'CART_TOTAL'), true, true); ?> </td>
                                <td><strong>
                                        <?php echo Labels::getLabel('LBL_Delivery/Shipping', $adminLangId); ?>:
                                    </strong>
                                    <?php echo '+' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'SHIPPING'), true, true);
                                    ?>
                                </td>
                            </tr>
                            <tr>
                                <?php if ($order['op_tax_collected_by_seller']) { ?>
                                    <td><?php if (empty($order['taxOptions'])) { ?>
                                            <strong><?php echo Labels::getLabel('LBL_Tax', $adminLangId); ?>:</strong>
                                            <?php
                                            echo '+' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'TAX'), true, true);
                                        } else {
                                            foreach ($order['taxOptions'] as $key => $val) {
                                            ?>
                                                <p><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?>:</strong> <?php echo CommonHelper::displayMoneyFormat($val['value']); ?></p>
                                        <?php
                                            }
                                        }
                                        ?>
                                    </td>
                                <?php } ?>
                                <?php
                                $colspan = 2;
                                if ($order['order_is_rfq'] == AppConstants::NO) {
                                    $colspan = 1;
                                ?>
                                    <td><strong><?php echo Labels::getLabel('LBL_Volume_Discount', $adminLangId); ?>: </strong> <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'VOLUME_DISCOUNT'), true, true); ?> </td>
                                <?php } ?>
                                <td colspan="<?php echo $colspan; ?>"><strong><?php echo Labels::getLabel('LBL_Order_Total', $adminLangId); ?>: </strong> <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'netamount', false, User::USER_TYPE_SELLER), true, true); ?>
                                </td>
                            </tr>

                            <?php if ($order['order_is_rfq'] == AppConstants::YES) { ?>
                                <tr>
                                    <td><strong><?php echo Labels::getLabel('LBL_Total_Paid', $adminLangId); ?> : </strong> <?php echo CommonHelper::displayMoneyFormat($order['order_total_paid'], true, true); ?></td>
                                    <td><strong><?php echo Labels::getLabel('LBL_Pending_Amount', $adminLangId); ?>: </strong> <?php echo CommonHelper::displayMoneyFormat($order['order_net_amount'] - $order['order_total_paid'], true, true); ?></td>
                                <tr>
                                <?php } ?>

                                <!-- [ SERVICES DATA -->
                                <?php if (count($servicesRows) > 0) { ?>
                                <tr class="service-heading-tr">
                                    <td colspan="3">
                                        <strong>
                                            <?php echo Labels::getLabel('LBL_Services', $adminLangId); ?>
                                        </strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <strong><?php echo Labels::getLabel('LBL_Commission_Charged', $adminLangId); ?>:
                                        </strong><?php echo CommonHelper::displayMoneyFormat($servicesTotalCommission, true, true); ?>
                                    </td>
                                    <td><strong><?php echo Labels::getLabel('LBL_Cart_Total', $adminLangId); ?>:</strong><?php echo CommonHelper::displayMoneyFormat($servicesTotalNetAmount, true, true); ?> </td>
                                    <td>
                                        <strong>
                                            <?php echo Labels::getLabel('LBL_Delivery/Shipping', $adminLangId); ?>:
                                        </strong>
                                        <?php echo '+' . CommonHelper::displayMoneyFormat($servicesShippingTotal, true, true);
                                        ?>
                                        <p class="mt-2">
                                            <strong>
                                                <?php echo Labels::getLabel('LBL_Tax', $adminLangId); ?>:
                                            </strong>
                                            <?php echo '+' . CommonHelper::displayMoneyFormat($servicesTaxTotal, true, true);
                                            ?>
                                        </p>
                                    </td>
                                </tr>
                            <?php } ?>
                            <!-- ]-->

                        </table>
                    </div>
                </section>
                <div class="row row--cols-group">
                    <div class="col-lg-6 col-md-6 col-sm-6">
                        <section class="section">
                            <div class="sectionhead">
                                <h4><?php echo Labels::getLabel('LBL_Seller/_Customer_Details', $adminLangId); ?></h4>
                            </div>
                            <div class="row space">
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <h5><?php echo Labels::getLabel('LBL_Seller_Details', $adminLangId); ?></h5>
                                    <p><strong><?php echo Labels::getLabel('LBL_Shop_Name', $adminLangId); ?>:</strong><?php echo $order["op_shop_name"] ?><br><strong><?php echo Labels::getLabel('LBL_Name', $adminLangId); ?>:
                                        </strong><?php echo $order["op_shop_owner_name"] ?><br><strong><?php echo Labels::getLabel('LBL_Email_ID', $adminLangId); ?>:</strong>
                                        <?php echo $order["op_shop_owner_email"] ?><br><strong><?php echo Labels::getLabel('LBL_Phone', $adminLangId); ?>:</strong> <?php echo $order["op_shop_owner_phone"] ?><br />
                                        <strong><?php echo Labels::getLabel('LBL_Shop_Address', $adminLangId); ?>:</strong>
                                        <br />
                                        <?php
                                        $shopAddressTxt = $shopAddress['shop_name'] . '<br>';
                                        if ($shopAddress['shop_address_line_1'] != '') {
                                            $shopAddressTxt .= $shopAddress['shop_address_line_1'] . '<br>';
                                        }

                                        if ($shopAddress['shop_address_line_2'] != '') {
                                            $shopAddressTxt .= $shopAddress['shop_address_line_2'] . '<br>';
                                        }

                                        if ($shopAddress['shop_city'] != '') {
                                            $shopAddressTxt .= $shopAddress['shop_city'] . ',';
                                        }

                                        if ($shopAddress['state_identifier'] != '') {
                                            $shopAddressTxt .= $shopAddress['state_identifier'] . ', ';
                                        }

                                        if ($shopAddress['shop_postalcode'] != '') {
                                            $shopAddressTxt .= '-' . $shopAddress['shop_postalcode'] . '<br>';
                                        }

                                        if ($shopAddress['country_name'] != '') {
                                            $shopAddressTxt .= $shopAddress['country_name'] . '';
                                        } elseif ($shopAddress['country_code'] != '') {
                                            $shopAddressTxt .= $shopAddress['country_code'] . '';
                                        }

                                        if ($shopAddress['shop_phone'] != '') {
                                            $shopAddressTxt .= '<br>' . $shopAddress['shop_phone'];
                                        }

                                        if (isset($orderDetail['op_shop_owner_email'])) {
                                            $shopAddressTxt .= '<br>' . $orderDetail['op_shop_owner_email'];
                                        }

                                        $shopAddressTxt .= '<br>' . Labels::getLabel('LBL_Shop_URL:', $adminLangId) . ' <a href="' . CommonHelper::generateFullUrl('shops', 'view', [$shopAddress['shop_id']], CONF_WEBROOT_FRONT_URL) . '">' . CommonHelper::generateFullUrl('shops', 'view', [$shopAddress['shop_id']], CONF_WEBROOT_FRONT_URL) . '</a>';
                                        echo $shopAddressTxt;
                                        ?>
                                    </p>


                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <h5><?php echo Labels::getLabel('LBL_Customer_Details', $adminLangId); ?></h5>
                                    <p><strong><?php echo Labels::getLabel('LBL_Name', $adminLangId); ?>: </strong><?php echo $order["buyer_name"] ?><br><strong><?php echo Labels::getLabel('LBL_UserName', $adminLangId); ?>:
                                        </strong><?php echo $order["buyer_username"]; ?><br><strong><?php echo Labels::getLabel('LBL_Email_ID', $adminLangId); ?>:</strong><?php echo $order["buyer_email"] ?><br><strong><?php echo Labels::getLabel('LBL_Phone', $adminLangId); ?>:</strong>
                                        <?php echo $order["buyer_phone"] ?></p>
                                </div>
                            </div>
                        </section>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-6">
                        <section class="section">
                            <div class="sectionhead">
                                <h4><?php echo Labels::getLabel('LBL_Billing_/_Shipping_Details', $adminLangId); ?></h4>
                            </div>
                            <div class="row space">
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <h5><?php echo Labels::getLabel('LBL_Billing_Details', $adminLangId); ?> </h5>
                                    <p><strong><?php echo $order['billingAddress']['oua_name']; ?></strong><br> <?php
                                                                                                                $billingAddress = '';
                                                                                                                if ($order['billingAddress']['oua_address1'] != '') {
                                                                                                                    $billingAddress .= $order['billingAddress']['oua_address1'] . '<br>';
                                                                                                                }

                                                                                                                if ($order['billingAddress']['oua_address2'] != '') {
                                                                                                                    $billingAddress .= $order['billingAddress']['oua_address2'] . '<br>';
                                                                                                                }

                                                                                                                if ($order['billingAddress']['oua_city'] != '') {
                                                                                                                    $billingAddress .= $order['billingAddress']['oua_city'] . ',';
                                                                                                                }

                                                                                                                if ($order['billingAddress']['oua_zip'] != '') {
                                                                                                                    $billingAddress .= ' ' . $order['billingAddress']['oua_state'];
                                                                                                                }

                                                                                                                if ($order['billingAddress']['oua_zip'] != '') {
                                                                                                                    $billingAddress .= '-' . $order['billingAddress']['oua_zip'];
                                                                                                                }

                                                                                                                if ($order['billingAddress']['oua_phone'] != '') {
                                                                                                                    $billingAddress .= '<br>Phone: ' . $order['billingAddress']['oua_phone'];
                                                                                                                }
                                                                                                                echo $billingAddress;
                                                                                                                ?><br>
                                    </p>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <?php if (!empty($order['shippingAddress'])) { ?>
                                        <h5><?php echo Labels::getLabel('LBL_Shipping_Details', $adminLangId); ?></h5>
                                        <p>
                                            <strong>
                                                <?php echo $order['shippingAddress']['oua_name']; ?></strong><br>
                                        <?php
                                        $shippingAddress = '';
                                        if ($order['shippingAddress']['oua_address1'] != '') {
                                            $shippingAddress .= $order['shippingAddress']['oua_address1'] . '<br>';
                                        }

                                        if ($order['shippingAddress']['oua_address2'] != '') {
                                            $shippingAddress .= $order['shippingAddress']['oua_address2'] . '<br>';
                                        }

                                        if ($order['shippingAddress']['oua_city'] != '') {
                                            $shippingAddress .= $order['shippingAddress']['oua_city'] . ',';
                                        }

                                        if ($order['shippingAddress']['oua_zip'] != '') {
                                            $shippingAddress .= ' ' . $order['shippingAddress']['oua_state'];
                                        }

                                        if ($order['shippingAddress']['oua_zip'] != '') {
                                            $shippingAddress .= '-' . $order['shippingAddress']['oua_zip'];
                                        }

                                        if ($order['shippingAddress']['oua_phone'] != '') {
                                            $shippingAddress .= '<br>Phone: ' . $order['shippingAddress']['oua_phone'];
                                        }

                                        echo $shippingAddress;
                                    }
                                        ?>
                                </div>
                            </div>
                        </section>
                    </div>
                </div>
                <section class="section">
                    <div class="sectionhead">
                        <h4><?php echo Labels::getLabel('LBL_Order_Details', $adminLangId); ?></h4>
                    </div>
                    <div class="sectionbody">
                        <?php $colCount = 9; ?>
                        <table class="table product-table">
                            <tr>
                                <th>#</th>
                                <th><?php echo Labels::getLabel('LBL_Product_Name', $adminLangId); ?></th>
                                <th><?php echo Labels::getLabel('LBL_Shipping', $adminLangId); ?></th>
                                <?php if ($order['order_is_rfq'] == AppConstants::NO) { ?>
                                    <th><?php echo Labels::getLabel('LBL_Unit_Price', $adminLangId); ?></th>
                                <?php } ?>
                                <th><?php echo Labels::getLabel('LBL_Qty', $adminLangId); ?></th>
                                <?php
                                //if ($shippingHanldedBySeller) { $colCount ++;
                                ?>
                                <th><?php echo Labels::getLabel('LBL_Shipping', $adminLangId); ?></th>
                                <?php //} 
                                ?>
                                <?php
                                //if ($order['op_tax_collected_by_seller']) { $colCount ++;
                                ?>
                                <th><?php echo Labels::getLabel('LBL_Tax', $adminLangId); ?></th>
                                <?php //} 
                                ?>
                                <?php if ($order['order_is_rfq'] == AppConstants::NO) { ?>
                                    <th><?php echo Labels::getLabel('LBL_Discount', $adminLangId); ?></th>
                                <?php } ?>
                                <th><?php echo Labels::getLabel('LBL_Total', $adminLangId); ?></th>
                            </tr>
                            <tr class="product-row">
                                <td>#</td>
                                <td><?php
                                    $txt = '';
                                    if ($order['op_selprod_title'] != '') {
                                        $txt .= $order['op_selprod_title'] . '<br/>';
                                    }
                                    $txt .= $order['op_product_name'];
                                    $txt .= '<br/>';
                                    if (!empty($order['op_brand_name'])) {
                                        $txt .= Labels::getLabel('LBL_Brand', $adminLangId) . ': ' . $order['op_brand_name'];
                                    }
                                    if (!empty($order['op_brand_name']) && !empty($order['op_selprod_options'])) {
                                        $txt .= ' | ';
                                    }
                                    if ($order['op_selprod_options'] != '') {
                                        $txt .= $order['op_selprod_options'];
                                    }
                                    if ($order['op_selprod_sku'] != '') {
                                        $txt .= '<br/>' . Labels::getLabel('LBL_SKU', $adminLangId) . ':  ' . $order['op_selprod_sku'];
                                    }
                                    if ($order['op_product_model'] != '') {
                                        $txt .= '<br/>' . Labels::getLabel('LBL_Model', $adminLangId) . ':  ' . $order['op_product_model'];
                                    }
                                    echo $txt;
                                    ?></td>
                                <td><strong><?php echo Labels::getLabel('LBL_Shipping_Class', $adminLangId); ?>: </strong><?php echo CommonHelper::displayNotApplicable($adminLangId, $order["op_shipping_duration_name"]); ?><br />
                                    <strong><?php echo Labels::getLabel('LBL_Duration', $adminLangId); ?>: </strong><?php echo CommonHelper::displayNotApplicable($adminLangId, $order["op_shipping_durations"]); ?>
                                </td>
                                <?php if ($order['order_is_rfq'] == AppConstants::NO) { ?>
                                    <td><?php echo CommonHelper::displayMoneyFormat($order["op_unit_price"], true, true); ?></td>
                                <?php } ?>
                                <td><?php echo $order["op_qty"] ?></td>
                                <?php // if ($shippingHanldedBySeller) {
                                ?> <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'SHIPPING'), true, true); ?></td>
                                <?php //} 
                                ?>
                                <?php // if ($order['op_tax_collected_by_seller']) { 
                                ?>
                                <td><?php
                                    if (empty($order['taxOptions'])) {
                                        echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'TAX'), true, true);
                                    } else {
                                        foreach ($order['taxOptions'] as $key => $val) {
                                    ?>
                                            <p><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?>:</strong> <?php echo CommonHelper::displayMoneyFormat($val['value']); ?></p>
                                    <?php
                                        }
                                    }
                                    ?>
                                </td>
                                <?php // } 
                                ?>
                                <?php if ($order['order_is_rfq'] == AppConstants::NO) { ?>
                                    <td>
                                        <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'VOLUME_DISCOUNT'), true, true); ?>
                                    </td>
                                <?php } ?>
                                <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'netamount', false, User::USER_TYPE_SELLER), true, true); ?></td>
                            </tr>

                            <!-- [ RFQ ATTACHED SERVICES -->
                            <?php
                            if (!empty($rfqServices)) {
                                foreach ($rfqServices as $service) {
                                    $serviceAttachment = (isset($attachments[$service['rfqattser_selprod_id']])) ? $attachments[$service['rfqattser_selprod_id']] : [];
                            ?>
                                    <tr>
                                        <td colspan="7"><?php echo Labels::getLabel('LBL_Attached_Services', $adminLangId); ?></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td><?php echo $service['selprod_title']; ?>
                                            <?php if (!empty($serviceAttachment) && !$print) { ?>
                                                <div class="pic--cell-left">
                                                    <ul class="order-service-docs">
                                                        <?php
                                                        $imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif');
                                                        foreach ($serviceAttachment as $attachment) {
                                                            $attachmentId = $attachment['afile_id'];
                                                            $ext = pathinfo($attachment['afile_name'], PATHINFO_EXTENSION);
                                                            $documentUrl = CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER, true, 50, 50]);
                                                            echo "<li><span id='document-js-" . $attachmentId . "'>";
                                                            if (in_array($ext, $imageType)) {
                                                        ?>
                                                                <a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                                    <img src="<?php echo $documentUrl; ?>" alt="<?php echo $attachment['afile_name']; ?>" title="<?php echo $attachment['afile_name']; ?>" />
                                                                </a>
                                                            <?php } else { ?>
                                                                <a href="<?php echo CommonHelper::generateUrl('RequestForQuotes', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachmentId, AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER]); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                                    <i class="icn rfq-doc-file-icon">
                                                                        <svg class="svg">
                                                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                                        </svg>
                                                                    </i>
                                                                </a>
                                                        <?php
                                                            }
                                                            /* echo '<p class="doc-title"><span>' . $icon = $attachment["afile_name"] . '</span></p>'; */

                                                            echo "</span></li>";
                                                            /* $icon = '<i class="fa fa-download"></i>';
                                                              $link = CommonHelper::generateUrl('CounterOffer', 'downloadDigitalFile', array($attachment["afile_record_id"], $attachment["afile_id"], AttachedFile::FILETYPE_SERVICE_DOCUMENTS_FOR_SELLER));
                                                              echo '<a target="_blank" href="' . $link . '"><span>' . $attachment["afile_name"] . $icon . '</span></a>'; */
                                                        }
                                                        ?>
                                                    </ul>
                                                </div>
                                            <?php
                                            }
                                            ?>
                                        </td>
                                        <td>-</td>
                                        <td><?php echo $service['rfqattser_quantity']; ?></td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                    </tr>
                            <?php
                                }
                            }
                            ?>

                            <!-- ] -->

                            <?php if (count($servicesRows) > 0) { ?>
                                <tr class="no-border-row">
                                    <th colspan="<?php echo $colCount; ?>"><?php echo Labels::getLabel('LBL_Services', $adminLangId); ?></th>
                                </tr>
                                <?php
                                foreach ($servicesRows as $service) {
                                    $taxOptionJson = $service['op_product_tax_options'];
                                    $serviceTaxOptions = json_decode(FatUtility::decodeHtmlEntities($taxOptionJson), true);
                                    $service['taxOptions'] = $serviceTaxOptions;
                                ?>
                                    <tr class="no-border-row">
                                        <td>#</td>
                                        <td><?php
                                            $txt = '';
                                            if ($service['op_selprod_title'] != '') {
                                                $txt .= $service['op_selprod_title'] . '<br/>';
                                            }
                                            echo $txt;
                                            ?>
                                        </td>
                                        <td><strong><?php echo Labels::getLabel('LBL_Shipping_Class', $adminLangId); ?>: </strong><?php echo CommonHelper::displayNotApplicable($adminLangId, $service["op_shipping_duration_name"]); ?><br />
                                            <strong><?php echo Labels::getLabel('LBL_Duration', $adminLangId); ?>: </strong><?php echo CommonHelper::displayNotApplicable($adminLangId, $service["op_shipping_durations"]); ?>
                                        </td>
                                        <td><?php echo CommonHelper::displayMoneyFormat($service["op_unit_price"], true, true); ?></td>
                                        <td><?php echo $service["op_qty"] ?></td>

                                        <td>
                                            <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'SHIPPING'), true, true); ?>
                                        </td>
                                        <td>
                                            <?php
                                            if (empty($service['taxOptions'])) {
                                                echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'TAX'), true, true);
                                            } else {
                                                foreach ($service['taxOptions'] as $key => $val) {
                                            ?>
                                                    <p><strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?>:</strong> <?php echo CommonHelper::displayMoneyFormat($val['value']); ?></p>
                                            <?php
                                                }
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'VOLUME_DISCOUNT'), true, true); ?>
                                        </td>
                                        <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'netamount', false, User::USER_TYPE_SELLER), true, true); ?>
                                            <a href="<?php echo CommonHelper::generateUrl('sellerOrders', 'view', [$service['op_id']]); ?>" class="btn btn-secondary btn-sm" title="<?php echo Labels::getLabel('LBL_Manage_Order', $adminLangId); ?>"><i class="far fa-eye icon"></i></a>
                                            <a href="<?php echo CommonHelper::generateUrl('sellerOrders', 'cancelOrder', [$service['op_id']]); ?>" class="btn btn-secondary btn-sm" title="<?php echo Labels::getLabel('LBL_Cancel', $adminLangId); ?>"><i class="fas fa-times"></i></a>
                                        </td>
                                    </tr>
                                <?php } ?>

                            <?php } ?>
                        </table>
                        <!-- [ SERVICE DOCUMENTS LISTING SECTION -->
                        <?php if (!empty($quality_certificates && !$print)) { ?>
                            <div class="uploaded--documents">
                                <h6><?php echo Labels::getLabel('LBL_Quality_Certificates', $adminLangId); ?></h6>
                                <?php
                                foreach ($quality_certificates as $document) {
                                    $attachmentId = $document['afile_id'];
                                    $ext = pathinfo($document['afile_name'], PATHINFO_EXTENSION);
                                    $documentUrl = CommonHelper::generateFullFileUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type'], true, 70, 70], CONF_WEBROOT_FRONTEND);
                                ?>
                                    <span id="document-js-<?php echo $document['afile_id'] ?>">
                                        <?php if (in_array($ext, $imageType)) {
                                        ?>
                                            <a href="<?php echo CommonHelper::generateFullFileUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']], CONF_WEBROOT_FRONTEND); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                <img src="<?php echo $documentUrl; ?>" alt="<?php echo $document['afile_name']; ?>" title="<?php echo $document['afile_name']; ?>" />
                                            </a>
                                        <?php } else { ?>
                                            <a href="<?php echo CommonHelper::generateFullFileUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']], CONF_WEBROOT_FRONTEND); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                <i class="icn rfq-doc-file-icon">
                                                    <svg class="svg">
                                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                    </svg>
                                                </i>
                                            </a>
                                        <?php
                                        }
                                        echo '<p class="doc-title"><a href="' . CommonHelper::generateFullFileUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']], CONF_WEBROOT_FRONTEND) . '"><span>' . $document["afile_name"] . '</a></span></p>';
                                        ?>
                                    </span>
                                <?php } ?>
                            </div>
                        <?php } ?>
                        <!-- ] -->
                        <!-- [ SERVICE DOCUMENTS LISTING SECTION -->
                        <?php if (!empty($service_documents && !$print)) { ?>
                            <div class="uploaded--documents">
                                <h6><?php echo Labels::getLabel('LBL_Service_Documents', $adminLangId); ?></h6>
                                <?php
                                foreach ($service_documents as $document) {
                                    $attachmentId = $document['afile_id'];
                                    $ext = pathinfo($document['afile_name'], PATHINFO_EXTENSION);
                                    $documentUrl = CommonHelper::generateFullFileUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type'], true, 70, 70], CONF_WEBROOT_FRONTEND);
                                ?>
                                    <span id="document-js-<?php echo $document['afile_id'] ?>">
                                        <?php if (in_array($ext, $imageType)) {
                                        ?>
                                            <a href="<?php echo CommonHelper::generateFullFileUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']], CONF_WEBROOT_FRONTEND); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                <img src="<?php echo $documentUrl; ?>" alt="<?php echo $document['afile_name']; ?>" title="<?php echo $document['afile_name']; ?>" />
                                            </a>
                                        <?php } else { ?>
                                            <a href="<?php echo CommonHelper::generateFullFileUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']], CONF_WEBROOT_FRONTEND); ?>" title="<?php echo Labels::getLabel('LBL_Download_file', $adminLangId); ?>">
                                                <i class="icn rfq-doc-file-icon">
                                                    <svg class="svg">
                                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions" href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#dash-my-subscriptions"></use>
                                                    </svg>
                                                </i>
                                            </a>
                                        <?php
                                        }
                                        echo '<p class="doc-title"><a href="' . CommonHelper::generateFullFileUrl('buyer', 'downloadOrderDocument', [$document["afile_record_id"], $document["afile_id"], $document['afile_type']], CONF_WEBROOT_FRONTEND) . '"><span>' . $document["afile_name"] . '</a></span></p>';
                                        ?>
                                    </span>
                                <?php } ?>
                            </div>
                        <?php } ?>
                        <!-- ] -->
                    </div>
                </section>
                <?php if (!empty($digitalDownloads) && !$print) { ?>
                    <section class="section no-print">
                        <div class="sectionhead">
                            <h4><?php echo Labels::getLabel('LBL_Downloads', $adminLangId); ?></h4>
                        </div>
                        <div class="sectionbody">
                            <table class="table">
                                <tr>
                                    <th><?php echo Labels::getLabel('LBL_Sr_No', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_File', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Language', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Downloaded_count', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Expired_on', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Action', $adminLangId); ?></th>
                                </tr>
                                <?php
                                $sr_no = 1;
                                foreach ($digitalDownloads as $key => $row) {
                                    $lang_name = Labels::getLabel('LBL_All', $adminLangId);
                                    if ($row['afile_lang_id'] > 0) {
                                        $lang_name = $allLanguages[$row['afile_lang_id']]['language_name'];
                                    }
                                    if ($row['downloadable']) {
                                        $fileName = '<a href="' . CommonHelper::generateUrl('SellerOrders', 'digitalDownloads', array($row['afile_id'], $row['afile_record_id'])) . '">' . $row['afile_name'] . '</a>';
                                    } else {
                                        $fileName = $row['afile_name'];
                                    }
                                    $downloads = '<a href="' . CommonHelper::generateUrl('SellerOrders', 'digitalDownloads', array($row['afile_id'], $row['afile_record_id'])) . '">' . Labels::getLabel('LBL_Downloads', $adminLangId) . '</a>';

                                    $expiry = Labels::getLabel('LBL_N/A', $adminLangId);
                                    if ($row['expiry_date'] != '') {
                                        $expiry = FatDate::Format($row['expiry_date']);
                                    }
                                ?>
                                    <tr>
                                        <td><?php echo $sr_no; ?></td>
                                        <td><?php echo $fileName; ?></td>
                                        <td><?php echo $lang_name; ?></td>
                                        <td><?php echo $row['afile_downloaded_times']; ?></td>
                                        <td><?php echo $expiry; ?></td>
                                        <td><?php echo $downloads; ?></td>
                                    </tr>
                                <?php } ?>
                            </table>
                        </div>
                    </section>
                <?php
                }
                if (!empty($digitalDownloadLinks) && !$print) {
                ?>
                    <section class="section no-print">
                        <div class="sectionhead">
                            <h4><?php echo Labels::getLabel('LBL_Downloads', $adminLangId); ?></h4>
                        </div>
                        <div class="sectionbody">
                            <table class="table">
                                <tr>
                                    <th><?php echo Labels::getLabel('LBL_Sr_No', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Link', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Download_times', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Downloaded_count', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Expired_on', $adminLangId); ?></th>
                                </tr>
                                <?php
                                $sr_no = 1;
                                foreach ($digitalDownloadLinks as $key => $row) {
                                    /* $fileName = '<a href="'.CommonHelper::generateUrl('Seller','downloadDigitalFile',array($row['afile_id'],$row['afile_record_id'],AttachedFile::FILETYPE_ORDER_PRODUCT_DIGITAL_DOWNLOAD)).'">'.$row['afile_name'].'</a>'; */
                                    /* $downloads = '<li><a href="'.CommonHelper::generateUrl('Seller','downloadDigitalFile',array($row['afile_id'],$row['afile_record_id'],AttachedFile::FILETYPE_ORDER_PRODUCT_DIGITAL_DOWNLOAD)).'"><i class="fa fa-download"></i></a></li>'; */

                                    $expiry = Labels::getLabel('LBL_N/A', $adminLangId);
                                    if ($row['expiry_date'] != '') {
                                        $expiry = FatDate::Format($row['expiry_date']);
                                    }

                                    $downloadableCount = Labels::getLabel('LBL_N/A', $adminLangId);
                                    if ($row['downloadable_count'] != -1) {
                                        $downloadableCount = $row['downloadable_count'];
                                    }
                                ?>
                                    <tr>
                                        <td><?php echo $sr_no; ?></td>
                                        <td><a target="_blank" href="<?php echo $row['opddl_downloadable_link']; ?>" title="<?php echo Labels::getLabel('LBL_Click_to_download', $adminLangId); ?>"><?php echo $row['opddl_downloadable_link']; ?></a></td>
                                        <td><?php echo $downloadableCount; ?></td>
                                        <td><?php echo $row['opddl_downloaded_times']; ?></td>
                                        <td><?php echo $expiry; ?></td>
                                    </tr>
                                <?php } ?>
                            </table>
                        </div>
                    </section>
                <?php
                }
                if (!empty($order['comments']) && !$print) {
                ?>
                    <section class="section no-print">
                        <div class="sectionhead">
                            <h4><?php echo Labels::getLabel('LBL_Order_Comments', $adminLangId); ?></h4>
                        </div>
                        <div class="sectionbody">
                            <table class="table">
                                <tr>
                                    <th><?php echo Labels::getLabel('LBL_Date_Added', $adminLangId); ?></td>
                                    <th><?php echo Labels::getLabel('LBL_Customer_Notified', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Status', $adminLangId); ?></th>
                                    <th><?php echo Labels::getLabel('LBL_Comments', $adminLangId); ?></th>
                                </tr>
                                <?php foreach ($order['comments'] as $row) { ?>
                                    <tr>
                                        <td><?php echo FatDate::format($row['oshistory_date_added']); ?></td>
                                        <td><?php echo $yesNoArr[$row['oshistory_customer_notified']]; ?></td>
                                        <td><?php echo $orderStatuses[$row['oshistory_orderstatus_id']]; ?></td>
                                        <td><?php echo nl2br($row['oshistory_comments']); ?>
                                            <?php
                                            echo ($row['oshistory_orderstatus_id'] > 0) ? $orderStatuses[$row['oshistory_orderstatus_id']] : CommonHelper::displayNotApplicable($adminLangId, '');
                                            echo ($row['oshistory_tracking_number']) ? ': ' . Labels::getLabel('LBL_Tracking_Number', $adminLangId) . ' ' . $row['oshistory_tracking_number'] . " VIA <em>" . $row['op_shipping_duration_name'] . "</em>" : '';
                                            ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </table>
                        </div>
                    </section>
                <?php
                }
                if ($displayShippingUserForm) {
                ?>
                    <section class="section">
                        <div class="sectionhead">
                            <h4><?php echo Labels::getLabel('LBL_Assign_to_shipping_company_user', $adminLangId); ?></h4>
                        </div>
                        <div class="sectionbody space">
                            <?php
                            $shippingUserFrm->setFormTagAttribute('onsubmit', 'updateShippingCompany(this); return(false);');
                            $shippingUserFrm->setFormTagAttribute('class', 'web_form form_horizontal');
                            $shippingUserFrm->developerTags['colClassPrefix'] = 'col-md-';
                            $shippingUserFrm->developerTags['fld_default_col'] = 12;
                            echo $shippingUserFrm->getFormHtml();
                            ?>
                        </div>
                    </section>
                <?php }
                if ($displayForm && !$print) { ?>
                    <section class="section no-print">
                        <div class="sectionhead">
                            <h4><?php echo Labels::getLabel('LBL_Comments_on_order', $adminLangId); ?></h4>
                        </div>
                        <div class="sectionbody space">
                            <?php
                            $frm->setFormTagAttribute('onsubmit', 'updateStatus(); return(false);');
                            $frm->setFormTagAttribute('class', 'web_form');

                            $frm->developerTags['colClassPrefix'] = 'col-md-';
                            $frm->developerTags['fld_default_col'] = 12;

                            $fldTracking = $frm->getField('tracking_number');
                            $fldTracking->setWrapperAttribute('class', 'div_tracking_number');

                            $fldQc = $frm->getField('quality_certificate');
                            $fldQc->setWrapperAttribute('class', 'quality_certificate--js');
                            /* $fldQc->setFieldTagAttribute('onChange', 'updateStatus()'); */

                            echo $frm->getFormHtml();
                            ?>
                        </div>
                    </section>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<?php if ($print) { ?>
    <script>
        window.print();
        window.onafterprint = function() {
            location.href = history.back();
        }
    </script>
<?php } ?>
<?php if ($order['op_status_id'] != FatApp::getConfig("CONF_DEFAULT_QUALITY_INSPECTION_ORDER_STATUS")) { ?>
    <script>
        $(document).ready(function() {
            $(".quality_certificate--js").hide();
        });
    </script>
<?php } ?>