<?php defined('SYSTEM_INIT') or die('Invalid Usage.');?> 
<?php
$reasonArrGrouping = [];
if (!empty($reasonsArr)) {
    foreach($reasonsArr as $reason) {
        $reasonArrGrouping[$reason['reasontorule_rule_id']][] = $reason['rcr_title'];
    }
}

$arr_flds = array(
    'rfqcrule_label'=>Labels::getLabel('LBL_Rule_label', $adminLangId),
    'rfqcrule_reasons'=>Labels::getLabel('LBL_Reasons', $adminLangId),
    'rfqcrule_return_amount'=>Labels::getLabel('LBL_Return_Amount', $adminLangId),
    'rfqcrule_penalty_to_seller'=>Labels::getLabel('LBL_Apply_Penalty_on_seller', $adminLangId),
    'rfqcrule_active'=>Labels::getLabel('LBL_Status', $adminLangId),
    'action'=>Labels::getLabel('LBL_Action', $adminLangId),
);

if (User::USER_TYPE_BUYER == $rfqcruleType) {
    unset($arr_flds['rfqcrule_penalty_to_seller']);
}

if (User::USER_TYPE_SELLER == $rfqcruleType) {
    unset($arr_flds['rfqcrule_return_amount']);
}

$tbl = new HtmlElement('table', array('width'=>'100%', 'class'=>'table table-responsive table--hovered'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    $e = $th->appendElement('th', array(), $val);
}

foreach ($records as $sn => $row) {
    $tr = $tbl->appendElement('tr', array());

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'rfqcrule_reasons':
                $str = '';
                if (!empty($reasonArrGrouping[$row['rfqcrule_id']])) {
                    foreach($reasonArrGrouping[$row['rfqcrule_id']] as $ruleReason) {
                        $str .= '- '.$ruleReason.'<br>';
                    }
                }
                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'rfqcrule_active':
                $active = "";
                $activeClass = '';
                if ($row['rfqcrule_active']) {
                    $active = 'checked="checked"';
                    $activeClass = 'active';
                }
                $statusAct = '';
                if ($canEdit === true) {
                    $statusAct = ($row['rfqcrule_active']) ? 'toggleStatus(event, ' . $row["rfqcrule_id"] . ', ' . AppConstants::NO . ')' : 'toggleStatus(event, ' . $row["rfqcrule_id"] . ', ' . AppConstants::YES . ')';
                }
                $statusClass = ($canEdit === false) ? 'disabled' : '';
                    $str='<label class="statustab -txt-uppercase">
                    <input '.$active.' type="checkbox" id="switch'.$row['rfqcrule_id'].'" value="'.$row['rfqcrule_id'].'" onclick="'.$statusAct.'" class="switch-labels '.$activeClass.'"/>
                    <i class="switch-handles '.$statusClass.'"></i></label>';
                    $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'action':
                    if($canEdit){
                        $td->appendElement('a', array('href'=> 'javascript:void(0)', 'class'=>'btn btn-clean btn-sm btn-icon', 'title'=> Labels::getLabel('LBL_Edit',$adminLangId),"onclick"=>"rfqRuleForm(".$row['rfqcrule_id'].")"),'<i class="far fa-edit icon"></i>', true);
                    }
                break;
            case 'rfqcrule_return_amount':
                    $td->appendElement('plaintext', array(), $row[$key].'%', true);
                break;
            case 'rfqcrule_penalty_to_seller':
                                            $penalty = Labels::getLabel('LBL_No', $adminLangId);
                                            if ($row[$key] == 1) {
                                                $penalty = Labels::getLabel('LBL_Yes', $adminLangId);
                                            }
                                            $td->appendElement('plaintext', array(), $penalty, true);
                                        break;
            case 'rfqcrule_reasons':
                    $td->appendElement('plaintext', array(), $row[$key].'%', true);
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}
echo $tbl->getHtml(); 

                    
