(function() {
    addReasonForm = function(id) {
        $.facebox(function() {
            reasonForm(id)
        });
    };

    reasonForm = function(id) {
        fcom.displayProcessing();
        data = 'rcr_id='+id;
        fcom.ajax(fcom.makeUrl('RfqCancelReasons', 'form'), data, function(t) {
            fcom.updateFaceboxContent(t);
        });
    };

    setupReason = function(frm) {
        if (!$(frm).validate()) return;
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(fcom.makeUrl('RfqCancelReasons', 'setup'), data, function(t) {
            reloadList();
            if (t.langId > 0) {
                editReasonLangForm(t.reasonId, t.langId);
                return;
            }
            $(document).trigger('close.facebox');
        });
    }

    editReasonLangForm = function(reasonId, langId, autoFillLangData = 0) {
        fcom.displayProcessing();
        fcom.ajax(fcom.makeUrl('RfqCancelReasons', 'langForm', [reasonId, langId, autoFillLangData]), '', function(t) {
            fcom.updateFaceboxContent(t);
        });
    };

    setupLangReason = function(frm) {
        if (!$(frm).validate()) return;
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(fcom.makeUrl('RfqCancelReasons', 'langSetup'), data, function(t) {
            reloadList();
            if (t.langId > 0) {
                editReasonLangForm(t.reasonId, t.langId);
                return;
            }
            $(document).trigger('close.facebox');
        });
    };
    
    toggleStatus = function( obj ) {
        if( !confirm(langLbl.confirmUpdateStatus) ){ return; }
        var reasonId = parseInt(obj.id);
        if (reasonId < 1) {
                fcom.displayErrorMessage(langLbl.invalidRequest);
                return false;
        }
        data = 'reasonId='+reasonId;
        fcom.ajax(fcom.makeUrl('RfqCancelReasons', 'changeStatus'), data, function(res) {
            var ans = $.parseJSON(res);
            if(ans.status == 1) {
                fcom.displaySuccessMessage(ans.msg);
                $(obj).toggleClass("active");
                setTimeout(function(){ reloadList(); }, 1000);
            } else {
                fcom.displayErrorMessage(ans.msg);
            }
        });
    };
    
    reloadList = function() {
        fcom.ajax(fcom.makeUrl('RfqCancelReasons', 'search'), '', function(res) {
            $('#listing').html(res);
        });
    }
	
})();

reloadList();
