$(document).ready(function(){
	searchProductCategories();
    getTotalBlock();
});

(function() {
	var currentPage = 1;
	var runningAjaxReq = false;
    var dv = "#listing";

    searchProductCategories = function(){
		var data = '';
		fcom.ajax(fcom.makeUrl('productCategories','search'),data,function(res){
			$(dv).html(res);
		});
	};

    getTotalBlock = function(){
		var data = '';
		fcom.ajax(fcom.makeUrl('productCategories','getTotalBlock'),data,function(res){
			$("#total-block").html(res);
		});
	};

    categoryForm = function(prodCatId){
        var data = '';
		fcom.ajax(fcom.makeUrl('productCategories','form', [prodCatId]),data,function(res){
            $(dv).html(res);
            if(prodCatId > 0){
                categoryImages(prodCatId,'icon',1);
                categoryImages(prodCatId,'banner',1);
				categoryImages(prodCatId, 'image', 1);
				categoryImages(prodCatId, 'collectionimage', 1);
            }
		});
    }

    setupCategory = function() {
        var frm = $('#frmProdCategory');
        var validator = $(frm).validation({errordisplay: 3});
        if (validator.validate() == false) {
            return false;
        }
        if (!$(frm).validate()) {
            return false;
        }
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(fcom.makeUrl('ProductCategories', 'setup'), data, function(t) {
            if(t.status == 1){
                searchProductCategories();
                getTotalBlock();
            }
        });
	};

    discardForm = function() {
        searchProductCategories();
        getTotalBlock();
    }

	deleteRecord = function(id){
		if(!confirm(langLbl.confirmDelete)){return;}
		data='id='+id;
		fcom.ajax(fcom.makeUrl('productCategories','deleteRecord'),data,function(res){
			var ans = $.parseJSON(res);
			if( ans.status == 1 ){
				fcom.displaySuccessMessage(ans.msg);
                searchProductCategories();
                getTotalBlock();
			} else {
				fcom.displayErrorMessage(ans.msg);
			}
		});
	};

	toggleStatus = function(e,obj,canEdit){
		if(canEdit == 0){
			e.preventDefault();
			return;
		}
		if(!confirm(langLbl.confirmUpdateStatus)){
			e.preventDefault();
			return;
		}
		var prodCatId = parseInt(obj.value);
		if( prodCatId < 1 ){
			fcom.displayErrorMessage(langLbl.invalidRequest);
			return false;
		}
		data='prodCatId='+prodCatId;
		fcom.displayProcessing();
		fcom.ajax(fcom.makeUrl('productCategories','changeStatus'),data,function(res){
		var ans = $.parseJSON(res);
			if( ans.status == 1 ){
				$(obj).toggleClass("active");
				fcom.displaySuccessMessage(ans.msg);
                searchProductCategories();
                getTotalBlock();
			} else {
				fcom.displa(ans.msg);
			}
		});
		$.systemMessage.close();
	};
    
    goToProduct = function(prodCatId){
        window.location.href = fcom.makeUrl('Products', 'form', [0,prodCatId]);
    };
    
    displaySubCategories = function(obj, catId = 0, data){
        if(catId > 0 ){
            var prodCatId = catId;
        }else{
            var prodCatId = $(obj).parent().parent().parent().attr('id');
        }
             
        if( $("#"+prodCatId+ ' ul.append-ul').length ){
            $("#"+prodCatId+ ' ul:first').show();
            if(catId == 0){ 
                togglePlusMinus(prodCatId);
            }
            if(catId > 0){
                updateCatOrder(data);
            }
            return false;
        }
        
        fcom.ajax(fcom.makeUrl('productCategories','getSubCategories'), 'prodCatId='+prodCatId, function(res){
            if($("#"+prodCatId).children('ul.append-ul').length){
                $("#"+prodCatId).children('ul.append-ul').append(res);
            }else{
                $("#"+prodCatId).append('<ul class="append-ul">'+res+'</ul>');
            }
            if(catId == 0){
                togglePlusMinus(prodCatId);
            }
            if(catId > 0){
                updateCatOrder(data);
            }
        });
    }

    togglePlusMinus = function(prodCatId){
        $("#"+prodCatId).children( 'div' ).children( '.sortableListsOpener' ).remove();
        if($("#"+prodCatId).hasClass('sortableListsClosed')){
            $("#"+prodCatId).removeClass('sortableListsClosed').addClass('sortableListsOpen');
            $("#"+prodCatId).children( 'div' ).append('<span class="sortableListsOpener" ><i class="fa fa-minus clickable sort-icon" onClick="hideItems(this)"></i></span>');  
        }else{
            $("#"+prodCatId).removeClass('sortableListsOpen').addClass('sortableListsClosed');
            $("#"+prodCatId).children( 'div' ).append('<span class="sortableListsOpener" ><i class="fa fa-plus c3 clickable sort-icon" onClick="displaySubCategories(this)"></i></span>');  
        }
        
        $("#"+prodCatId+ ' > ul:first > li:has(> ul)').children( 'div' ).children( '.sortableListsOpener' ).remove();
        $("#"+prodCatId+ ' > ul:first > li:has(> ul)').removeClass('sortableListsOpen').addClass('sortableListsClosed');
        $("#"+prodCatId+ ' > ul:first > li:has(> ul)').children( 'div' ).append('<span class="sortableListsOpener" ><i class="fa fa-plus c3 clickable sort-icon" onClick="displaySubCategories(this)"></i></span>');
   }

   hideItems = function(obj){
        var prodCatId = $(obj).parent().parent().parent().attr('id');
        $("#"+prodCatId+ ' ul').hide();
        $("#"+prodCatId).removeClass('sortableListsOpen').addClass('sortableListsClosed');
        var icon = $("#"+prodCatId).children( 'div' ).children( '.sortableListsOpener' ).remove();
        $("#"+prodCatId).children( 'div' ).append('<span class="sortableListsOpener" ><i class="fa fa-plus c3 clickable sort-icon" onClick="displaySubCategories(this)"></i></span>');
   }
   
   updateCatOrder = function(data){
        fcom.updateWithAjax(fcom.makeUrl('productCategories','updateOrder'), data, function(res){ 
            $("#js-cat-section").removeClass('overlay-blur');
        });
   }

	categoryImages = function (prodCatId, imageType, slide_screen, lang_id = 0) {

		fcom.ajax(fcom.makeUrl('ProductCategories', 'images', [prodCatId, imageType, lang_id, slide_screen]), '', function (t) {
			if(imageType=='icon') {
				$('#icon-image-listing').html(t);
                var prodCatId = $("[name='prodcat_id']").val();
                if(prodCatId == 0){
                    var iconImageId = $("#icon-image-listing li").attr('id');
                    var selectedLangId = $(".icon-language-js").val();
                    $("[name='cat_icon_image_id["+selectedLangId+"]']").val(iconImageId);
                }
			} else if(imageType=='banner') {
				$('#banner-image-listing').html(t);
                var bannerImageId = $("#banner-image-listing li").attr('id');
                var selectedLangId = $(".banner-language-js").val();
                var screen = $(".prefDimensions-js").val();
                $("[name='cat_banner_image_id["+selectedLangId+"_"+screen+"]']").val(bannerImageId);

			} else if (imageType == 'image') {
				$('#cat-image-listing').html(t);
				var catImageId = $("#cat-image-listing li").attr('id');
				var selectedLangId = $(".image-language-js").val();
				var screen = $(".prefDimensions-js").val();
				$("[name='cat_image_id[" + selectedLangId + "_" + screen + "]']").val(catImageId);
			} else if (imageType == 'collectionimage') {
				$('#cat-collectionimage-listing').html(t);
				var catImageId = $("#cat-collectionimage-listing li").attr('id');
				var selectedLangId = $(".collectionimage-language-js").val();
				var screen = $(".prefDimensions-js").val();
				$("[name='cat_collection_image_id[" + selectedLangId + "_" + screen + "]']").val(catImageId);
			}
		});
	};

    deleteImage = function(fileId, prodcatId, imageType, langId, slide_screen){
		if( !confirm(langLbl.confirmDeleteImage) ){ return; }
		fcom.updateWithAjax(fcom.makeUrl('productCategories', 'removeImage',[fileId,prodcatId,imageType,langId,slide_screen]), '', function(t) {
			//categoryImages( prodcatId, imageType, slide_screen, langId );
            if(imageType == 'icon') {
                $("#icon-image-listing").html('');
                $("[name='cat_icon_image_id["+langId+"]']").val('');
			} else if(imageType == 'banner') {
                $("#banner-image-listing").html('');
                $("[name='cat_banner_image_id["+langId+"_"+slide_screen+"]']").val('');
			} else if (imageType == 'image') {
				$("#cat-image-listing").html('');
				$("[name='cat_image_id[" + langId + "_" + slide_screen + "]']").val('');
			} else if (imageType == 'collectionimage') {
				$("#cat-collectionimage-listing").html('');
				$("[name='cat_collection_image_id[" + langId + "_" + slide_screen + "]']").val('');
			}
		});
	};

    translateData = function(item){
        var autoTranslate = $("input[name='auto_update_other_langs_data']:checked").length;
        var defaultLang = $(item).attr('defaultLang');
        var catName = $("input[name='prodcat_name["+defaultLang+"]']").val();
        var toLangId = $(item).attr('language');
        var alreadyOpen = $('#collapse_'+toLangId).hasClass('active');
        if(autoTranslate == 0 || catName == "" || alreadyOpen == true){
            return false;
        }
        var data = "catName="+catName+"&toLangId="+toLangId ;
        fcom.updateWithAjax(fcom.makeUrl('ProductCategories', 'translatedCategoryData'), data, function(t) {
            if(t.status == 1){
                $("input[name='prodcat_name["+toLangId+"]']").val(t.prodCatName);
            }
        });
    }

	bannerPopupImage = function(inputBtn){
		if (inputBtn.files && inputBtn.files[0]) {
	        fcom.ajax(fcom.makeUrl('ProductCategories', 'imgCropper'), '', function(t) {
				$.facebox(t,'faceboxWidth');
                var file = inputBtn.files[0];
	            var minWidth = document.frmProdCategory.banner_min_width.value;
	            var minHeight = document.frmProdCategory.banner_min_height.value;
	    		var options = {
	                aspectRatio: minWidth/minHeight,
	                data: {
	                    width: minWidth,
	                    height: minHeight,
	                },
	                minCropBoxWidth: minWidth,
	                minCropBoxHeight: minHeight,
	                toggleDragModeOnDblclick: false,
		        };
				$(inputBtn).val('');
		    	return cropImage(file, options, 'uploadCatImages', inputBtn);
	    	});
		}
	};

	popupCatImage = function (inputBtn) {
		if (inputBtn.files && inputBtn.files[0]) {
			fcom.ajax(fcom.makeUrl('Shops', 'imgCropper'), '', function (t) {
				$.facebox(t, 'faceboxWidth');
				var file = inputBtn.files[0];
				var minWidth = document.frmProdCategory.logo_min_width.value;
				var minHeight = document.frmProdCategory.logo_min_height.value;
				var options = {
					aspectRatio: 1 / 1,
					data: {
						width: minWidth,
						height: minHeight,
					},
					minCropBoxWidth: minWidth,
					minCropBoxHeight: minHeight,
					toggleDragModeOnDblclick: false,
				};
				$(inputBtn).val('');
				return cropImage(file, options, 'uploadCatImages', inputBtn);
			});
		}
	};

	popupCollImage = function (inputBtn) {
		if (inputBtn.files && inputBtn.files[0]) {
			fcom.ajax(fcom.makeUrl('Shops', 'imgCropper'), '', function (t) {
				$.facebox(t, 'faceboxWidth');
				var file = inputBtn.files[0];
				var minWidth = document.frmProdCategory.collection_image_min_width.value;
				var minHeight = document.frmProdCategory.collection_image_min_height.value;
				var options = {
					aspectRatio: minWidth / minHeight,
					data: {
						width: minWidth,
						height: minHeight,
					},
					minCropBoxWidth: minWidth,
					minCropBoxHeight: minHeight,
					toggleDragModeOnDblclick: false,
				};
				$(inputBtn).val('');
				return cropImage(file, options, 'uploadCatImages', inputBtn);
			});
		}
	};




    iconPopupImage = function(inputBtn){
		if (inputBtn.files && inputBtn.files[0]) {
	        fcom.ajax(fcom.makeUrl('Shops', 'imgCropper'), '', function(t) {
				$.facebox(t,'faceboxWidth');
                var file = inputBtn.files[0];
	            var minWidth = document.frmProdCategory.logo_min_width.value;
	            var minHeight = document.frmProdCategory.logo_min_height.value;
	    		var options = {
	                aspectRatio: 1 / 1,
	                data: {
	                    width: minWidth,
	                    height: minHeight,
	                },
	                minCropBoxWidth: minWidth,
	                minCropBoxHeight: minHeight,
	                toggleDragModeOnDblclick: false,
		        };
				$(inputBtn).val('');
    	  		return cropImage(file, options, 'uploadCatImages', inputBtn);
	    	});
		}
	};

	uploadCatImages = function(formData){
        var frmName = formData.get("frmName");
		var slideScreen = 0;
		var prodcatId = $("[name='prodcat_id']").val();
		if(frmName == 'frmCategoryIcon'){
			var afileId = $("#icon-image-listing li").attr('id');
			var langId = $("[name='icon_lang_id']").val();
			var fileType = $("[name='icon_file_type']").val();
			var imageType = 'icon';
		}
		else if (frmName == 'frmCategoryImage') {
			var afileId = $("#cat-image-listing li").attr('id');
			var langId = $("[name='image_lang_id']").val();
			var fileType = $("[name='image_file_type']").val();
			var imageType = 'image';
		} else if (frmName == 'frmCollectionCategoryImage') {
			var afileId = $("#cat-collectionimage-listing li").attr('id');
			var langId = $("[name='collection_image_lang_id']").val();
			var fileType = $("[name='collection_image_file_type']").val();
			var imageType = 'collectionimage';
		} else {
			var afileId = $("#banner-image-listing li").attr('id');
			var langId = $("[name='banner_lang_id']").val();
			var fileType = $("[name='banner_file_type']").val();
			slideScreen = $("[name='slide_screen']").val();
			var imageType = 'banner';
		}
		formData.append('prodcat_id', prodcatId);
        formData.append('slide_screen', slideScreen);
        formData.append('lang_id', langId);
        formData.append('file_type', fileType);
		formData.append('afile_id', afileId);
        $.ajax({
            url: fcom.makeUrl('ProductCategories', 'setUpCatImages'),
            type: 'post',
            dataType: 'json',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#loader-js').html(fcom.getLoader());
            },
            complete: function() {
                $('#loader-js').html(fcom.getLoader());
            },
			success: function(ans) {
				if(ans.status == 1){
					fcom.displaySuccessMessage(ans.msg);
					categoryImages(prodcatId,imageType,slideScreen,langId);
				} else {
					fcom.displayErrorMessage(ans.msg);
				}
				$(document).trigger('close.facebox');
			},
			error: function(xhr, ajaxOptions, thrownError) {
				alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
			}
        });
	}

})();



$(document).on('change','.icon-language-js',function(){
	var lang_id = $(this).val();
	var prodcat_id = $("input[name='prodcat_id']").val();
    var imageId = $("[name='cat_icon_image_id["+lang_id+"]']").val();
    if(prodcat_id == 0){
        if(imageId > 0){
            categoryImages(prodcat_id,'icon',0,lang_id);
        }else{
            $("#icon-image-listing").html('');
        }
    }else{
        categoryImages(prodcat_id,'icon',0,lang_id);
    }

});

$(document).on('change','.prefDimensions-js',function(){
	var slide_screen = $(this).val();
	var prodcat_id = $("input[name='prodcat_id']").val();
	var lang_id = $(".banner-language-js").val();
    var imageId = $("[name='cat_banner_image_id["+lang_id+"_"+slide_screen+"]']").val();
    if(prodcat_id == 0){
        if(imageId > 0 ){
            categoryImages(prodcat_id,'banner',slide_screen,lang_id);
        }else{
            $("#banner-image-listing").html('');
        }
    }else{
        categoryImages(prodcat_id,'banner',slide_screen,lang_id);
    }
});
