<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('class', 'web_form form');
$frm->setFormTagAttribute('onsubmit', 'setupCommission(this); return(false);');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 6;
$frm->getField('user_name');
?>
<section class="section">
    <div class="sectionhead">
        <h4><?php echo Labels::getLabel('LBL_Commission_Setup', $adminLangId); ?></h4>
    </div>
    <div class="sectionbody space">
        <div class="border-box border-box--space">
            <?php echo $frm->getFormHtml(); ?>
        </div>
    </div>
</section>
<script type="text/javascript">
    $("document").ready(function() {
        $('input[name=\'user_name\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function(request, response) {
                $.ajax({
                    url: fcom.makeUrl('Commission', 'userAutoComplete'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function(json) {
                        response($.map(json, function(item) {

                            $("#ui-id-1").css("z-index", '10');
                            $("#ui-id-2").css("z-index", '10');
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },
            select: function(event, ui) {
                $("input[name='commsetting_user_id']").val(ui.item.id);
            }
        });

        $('input[name=\'product\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function(request, response) {
                $.ajax({
                    url: fcom.makeUrl('Commission', 'productAutoComplete'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function(json) {
                        response($.map(json, function(item) {

                            $("#ui-id-1").css("z-index", '10');
                            $("#ui-id-2").css("z-index", '10');
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },

            select: function(event, ui) {
                $('input[name=\'product\']').val(ui.item.name);
                $('input[name=\'commsetting_product_id\']').val(ui.item.id);
            }
        });


        $('input[name=\'user_name\']').keyup(function() {
            $('input[name=\'commsetting_user_id\']').val('');
        });

        $('input[name=\'product\']').keyup(function() {
            $('input[name=\'commsetting_product_id\']').val('');
        });
    });
</script>