<?php

class TagsController extends AdminBaseController
{

    public function __construct($action)
    {
        parent::__construct($action);
        $this->admin_id = AdminAuthentication::getLoggedAdminId();
        $this->canView = $this->objPrivilege->canViewTags($this->admin_id, true);
        $this->canEdit = $this->objPrivilege->canEditTags($this->admin_id, true);
        $this->set("canView", $this->canView);
        $this->set("canEdit", $this->canEdit);
    }

    public function index()
    {
        $this->objPrivilege->canViewTags();
        $this->set('search', $this->searchForm());
        $this->_template->render(true, true);
    }

    public function search()
    {
        $userId = $this->admin_id;
        $searchForm = $this->searchForm();
        $post = $searchForm->getFormDataFromArray(FatApp::getPostedData());
        $page = FatApp::getPostedData('page', FatUtility::VAR_INT, 1);
        $pagesize = FatApp::getConfig('CONF_PAGE_SIZE', FatUtility::VAR_INT, 10);

        $srch = Tag::getSearchObject($this->adminLangId);
        $srch->joinTable(User::DB_TBL, 'LEFT OUTER JOIN', 'tag_user_id = user_id', 'tu');

        $srch->addCondition('tag_deleted', '=', 0);

        $keyword = FatApp::getPostedData('keyword', FatUtility::VAR_STRING, '');
        if ($keyword != '') {
            $srch->addCondition('tag_name', 'like', '%' . $keyword . '%');
        }

        $tagType = FatApp::getPostedData('tag_type', FatUtility::VAR_STRING, '');
        $typeArr = Tag::getTypeArr();
        if ($tagType != '' && array_key_exists($tagType, $typeArr)) {
            $srch->addCondition('tag_type', '=', $tagType);
        }

        $srch->addCondition('tag_type', '>', 0);
        $srch->addMultipleFields(array('t.*', 't_l.*', 'tu.user_name'));

        $srch->setPageNumber($page);
        $srch->setPageSize($pagesize);
        $srchRs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($srchRs);
        $this->set('arr_listing', $records);
        $this->set('adminLangId', $this->adminLangId);
        $this->set('pageCount', $srch->pages());
        $this->set('recordCount', $srch->recordCount());

        $this->set('page', $page);
        $this->set('pageSize', $pagesize);
        $this->set('postedData', $post);
        $this->set('typeArr', $typeArr);
        $this->set('canViewUsers', $this->objPrivilege->canViewUsers($this->admin_id, true));
        $this->set('canEdit', $this->objPrivilege->canEditProducts(AdminAuthentication::getLoggedAdminId(), true));
        $this->_template->render(false, false);
    }

    public function form(int $id = 0)
    {
        $userId = $this->admin_id;
        $tagData = array();
        if (0 < $id) {

            $tagData = Tag::getAttributesById($id);

            if (empty($tagData)) {
                FatUtility::exitWithErrorCode(404);
            }

            $tagLangData = Tag::getLangDataArr($id);

            if (!empty($tagLangData)) {
                foreach ($tagLangData as $langData) {
                    $tagData['tag_name'][$langData['taglang_lang_id']] = $langData['tag_name'];
                }
            }
        }

        $form = $this->getForm();
        $form->fill($tagData);

        $this->set('form', $form);
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        $this->set('siteDefaultLangId', $siteDefaultLangId);
        $languages = Language::getAllNames();
        unset($languages[$siteDefaultLangId]);
        $this->set('siteDefaultLangId', $siteDefaultLangId);
        $this->set('otherLanguages', $languages);
        $this->set('tagId', $id);


        $this->_template->render(false, false);
    }

    private function getForm()
    {
        $frm = new Form('tagForm', array('id' => 'tagForm'));

        $tagTypes = Tag::getTypeArr($this->adminLangId);
        $frm->addSelectBox(Labels::getLabel('LBL_Type', $this->adminLangId), 'tag_type', $tagTypes, '', array(), Labels::getLabel('LBL_Select', $this->adminLangId))->requirements()->setRequired(true);

        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);

        $languages = Language::getAllNames();
        foreach ($languages as $langId => $lang) {
            if ($langId == $siteDefaultLangId) {
                $frm->addRequiredField(Labels::getLabel('LBL_Name', $this->adminLangId), 'tag_name[' . $langId . ']');
            } else {
                $frm->addTextBox(Labels::getLabel('LBL_Name', $this->adminLangId), 'tag_name[' . $langId . ']');
            }
        }

        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
        unset($languages[$siteDefaultLangId]);
        if (!empty($translatorSubscriptionKey) && count($languages) > 0) {
            $frm->addCheckBox(Labels::getLabel('LBL_Translate_To_Other_Languages', $this->adminLangId), 'auto_update_other_langs_data', 1, array(), false, 0);
        }

        $frm->addHiddenField('', 'tag_id');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save', $this->adminLangId));
        return $frm;
    }

    public function setup()
    {
        $frm = $this->getForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $post) {
            Message::addErrorMessage($this->str_invalid_request);
            FatUtility::dieJsonError(Message::getHtml());
        }

        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);

        $tagId = FatUtility::int($post['tag_id']);

        $data = array(
            'tag_identifier' => $post['tag_name'][$siteDefaultLangId],
            'tag_admin_id' => $this->admin_id,
            'tag_type' => $post['tag_type'],
            'tag_active' => 1
        );

        $tagObj = new Tag($tagId);
        $tagObj->assignValues($data);

        if (!$tagObj->save()) {
			
			if(strpos(strtolower($tagObj->getError()), "for key 'tag_identifier'")!= false)
			{
				$message = "LBL_Tag_Already_Exists";
			}else{
				$message = $tagObj->getError();
			}
			
            Message::addErrorMessage(Labels::getLabel($message, $this->adminLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $tagId = $tagObj->getMainTableRecordId();

        $this->setupLangData($tagId, $post);

        $this->set('tag_id', $tagId);
        $this->set('msg', Labels::getLabel('LBL_Updated_Successfully', $this->adminLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function changeStatus()
    {
        $post = FatApp::getPostedData();
        $tagId = FatApp::getPostedData('tagId', FatUtility::VAR_INT, 0);
        if (empty($post) || 1 > $tagId || 0 > FatUtility::int($post['status'])) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Request', $this->adminLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $tagData = Tag::getAttributesById($tagId, ['tag_user_id']);

        /*if (empty($tagData['tag_user_id']) || $tagData['tag_user_id'] != $this->admin_id) {
            Message::addErrorMessage(Labels::getLabel('MSG_Unauthorized_access', $this->adminLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }*/

        $tagObj = new Tag($tagId);
        $response = $tagObj->changeStatus($post['status']);
        if (!$response) {
            Message::addErrorMessage($tagObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
		
		$rows = Product::getProductIdsByTagId($tagId);
        if (!empty($rows)) {
            FatApp::getDb()->deleteRecords(Product::DB_PRODUCT_TO_TAG, array( 'smt' => 'ptt_tag_id = ?', 'vals' => array( $tagId ) ));
            foreach ($rows as $row) {
                Tag::updateProductTagString($row['ptt_product_id']);
            }
        }

        $msg = Labels::getLabel('MSG_Status_Updated_Successfully', $this->adminLangId);
        FatUtility::dieJsonSuccess($msg);
    }

    public function deleteItem()
    {
        $post = FatApp::getPostedData();
        $tagId = FatApp::getPostedData('tagId', FatUtility::VAR_INT, 0);

        if (empty($post) || 1 > $tagId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Request', $this->adminLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $tagObj = new Tag($tagId);
        $response = $tagObj->deleteRecord(true);
        if (!$response) {
            Message::addErrorMessage($tagObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
		
		$rows = Product::getProductIdsByTagId($tagId);
        if (!empty($rows)) {
            FatApp::getDb()->deleteRecords(Product::DB_PRODUCT_TO_TAG, array( 'smt' => 'ptt_tag_id = ?', 'vals' => array( $tagId ) ));
            foreach ($rows as $row) {
                Tag::updateProductTagString($row['ptt_product_id']);
            }
        }
		
        $msg = Labels::getLabel('MSG_Record_Deleted_Successfully', $this->adminLangId);
        FatUtility::dieJsonSuccess($msg);
    }

    private function setupLangData(int $tagId, array $data)
    {
        $tagNames = (isset($data['tag_name'])) ? $data['tag_name'] : [];
        $autoUpdateOtherLangsData = isset($data['auto_update_other_langs_data']) ? FatUtility::int($data['auto_update_other_langs_data']) : 0;
        if (!empty($tagNames)) {

            $tagObj = new Tag($tagId);
            foreach ($tagNames as $langId => $tagName) {
                if (empty($tagName) && $autoUpdateOtherLangsData > 0) {
                    $tagObj->saveTranslatedProductLangData($langId);
                } else {
                    $tagData = array(
                        'taglang_tag_id' => $tagId,
                        'taglang_lang_id' => $langId,
                        'tag_name' => $tagName
                    );

                    if (!$tagObj->updateLangData($langId, $tagData)) {
                        Message::addErrorMessage(Labels::getLabel($tagObj->getError(), $this->adminLangId));
                        FatUtility::dieJsonError(Message::getHtml());
                    }
                }
            }
        }
    }

    private function searchForm()
    {
        $frm = new Form('frmSearchTags');
        $frm->addTextBox(Labels::getLabel('LBL_Search_By', $this->adminLangId), 'keyword');

        $tagTypes = Tag::getTypeArr($this->adminLangId);
        $frm->addSelectBox(Labels::getLabel('LBL_Type', $this->adminLangId), 'tag_type', $tagTypes);

        $fld_submit = $frm->addSubmitButton('&nbsp;', 'btn_submit', Labels::getLabel('LBL_Search', $this->adminLangId));
        $fld_cancel = $frm->addButton("", "btn_clear", Labels::getLabel('LBL_Clear_Search', $this->adminLangId));
        $fld_submit->attachField($fld_cancel);
        return $frm;
    }
}
