<?php

class RfqCancellationRulesController extends AdminBaseController
{

    public function __construct($action)
    {
        parent::__construct($action);
        $this->admin_id = AdminAuthentication::getLoggedAdminId();
    }

	public function index() {
		CommonHelper::redirectUserReferer();
	}

    public function search()
    {
        $this->objPrivilege->canEditRfqCancellationRules();
        $reasonsArr = [];
        $rfqcruleType = FatApp::getPostedData('rfqcrule_type', FatUtility::VAR_INT, 0);
        
        $srch = RfqCancellationRules::getSearchObject();
        $srch->addCondition('rfqcrule_type', '=', $rfqcruleType);
        $srchRs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($srchRs);
        
        if (!empty($records)) {
            $ruleIds = array_column($records, 'rfqcrule_id');
            $rfqCancelRules = new RfqCancellationRules();
            $reasonsArr = $rfqCancelRules->getReasonsArr($ruleIds, $this->adminLangId);
        }
        $this->set('records', $records);
        $this->set('reasonsArr', $reasonsArr);
        $this->set('rfqcruleType', $rfqcruleType);
        $this->set('adminLangId', $this->adminLangId);
        $this->set('canEdit', $this->objPrivilege->canEditOrderCancellationRequests($this->admin_id, true));
        $this->_template->render(false, false);
    }
    
    public function listingForBuyer()
    {
        $this->objPrivilege->canEditRfqCancellationRules();
        $this->set('adminLangId', $this->adminLangId);
        $this->set('canEdit', $this->objPrivilege->canEditOrderCancellationRequests($this->admin_id, true));
        $this->_template->render();
    }
    
    public function listingForSeller()
    {
        $this->objPrivilege->canEditRfqCancellationRules();
        $this->set('adminLangId', $this->adminLangId);
        $this->set('canEdit', $this->objPrivilege->canEditOrderCancellationRequests($this->admin_id, true));
        $this->_template->render();
    }
   
    public function form()
    {
        $this->objPrivilege->canEditRfqCancellationRules();

        $rfqCancelRuleId = FatApp::getPostedData('rfqcrule_id', FatUtility::VAR_INT, 0);
        $rfqRuleType = FatApp::getPostedData('rfqcrule_type', FatUtility::VAR_INT, 0);
        
        $frm = $this->getForm($rfqRuleType);
        $data = array('rfqcrule_id' => $rfqCancelRuleId);
        
        if (0 < $rfqCancelRuleId) {
            $data = RfqCancellationRules::getAttributesById($rfqCancelRuleId);

            $rfqCancelRules = new RfqCancellationRules();
            $ruleData = $rfqCancelRules->getReasonsArr([$rfqCancelRuleId], $this->adminLangId);
            if (!empty($ruleData)) {
                foreach($ruleData as $row) {
                    $data['rule_reasons'][] = $row['reasontorule_reason_id'];
                }
            }
        }
        $frm->fill($data);
        $this->set('frm', $frm);
        $this->set('rfqRuleType', $rfqRuleType);
        $this->set('adminLangId', $this->adminLangId);
        $this->_template->render(false, false);
    }
    
    
    private function getForm($reasonFor = User::USER_TYPE_BUYER)
    {
        $frm = new Form('frmRfqCancellationRules');
        $frm->addRequiredField(Labels::getLabel('LBL_Rule_Caption', $this->adminLangId), 'rfqcrule_label');
        $reasonsArr = RfqCancelReason::reasonsArr($reasonFor, $this->adminLangId);
        $frm->addCheckBoxes(Labels::getLabel("LBL_Choose_Reasons", $this->adminLangId), 'rule_reasons', $reasonsArr);
        
        if ($reasonFor == User::USER_TYPE_SELLER) {
            $frm->addCheckBox(Labels::getLabel("LBL_Deduct_commission_from_Seller_Wallet", $this->adminLangId), 'rfqcrule_penalty_to_seller', '1');
        } else {
            $qtyFld = $frm->addIntegerField(Labels::getLabel("LBL_return_amount", $this->adminLangId), 'rfqcrule_return_amount');
            $qtyFld->requirements()->setPositive();
            $qtyFld->requirements()->setRange('1', '100');
        }
        
        $frm->addHiddenField('', 'rfqcrule_id');
        $frm->addHiddenField('', 'rfqcrule_for');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save', $this->adminLangId));
       
        return $frm;
    }
    
    public function setupRule()
    {
        $this->objPrivilege->canEditRfqCancellationRules();
        $returnAmt = $penaltyToSeller = 0;
        
        $rfqcruleType = FatApp::getPostedData('rfqcrule_type', FatUtility::VAR_INT, 0);
        $frm = $this->getForm($rfqcruleType);
        
        $postedData = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false == $postedData) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }
        
        $rfqCancelRuleId = FatApp::getPostedData('rfqcrule_id', FatUtility::VAR_INT, 0);
        $rfqCanRules = new RfqCancellationRules();
        $validateReasons = $rfqCanRules->validateReasons($postedData['rule_reasons'], $rfqCancelRuleId, $this->adminLangId);
        
        if (!empty($validateReasons)) {
            foreach ($validateReasons as $row) {
                Message::addErrorMessage(sprintf(Labels::getLabel('MSG_already_attached_with', $this->adminLangId), $row['rcr_title'], $row['rfqcrule_label']));
            }
            FatUtility::dieJsonError(Message::getHtml());
        }
        
        if ($rfqcruleType == User::USER_TYPE_BUYER) {
            $returnAmt = $postedData['rfqcrule_return_amount'];
        } else {
            $penaltyToSeller = (isset($postedData['rfqcrule_penalty_to_seller']) && $postedData['rfqcrule_penalty_to_seller'] > 0) ? 1 : 0;
        }
        
        $data = array(
            'rfqcrule_type' => $rfqcruleType,
            'rfqcrule_label' => $postedData['rfqcrule_label'],
            'rfqcrule_return_amount' => $returnAmt,
            'rfqcrule_added_on' =>date('Y-m-d H:i:s'),
            'rfqcrule_penalty_to_seller' => $penaltyToSeller,
        );
        
        if ($rfqCancelRuleId == 0) {
            $data['rfqcrule_active'] = AppConstants::YES;
        }
        
        if ($rfqCancelRuleId > 0) {
            $rfqCanRules = new RfqCancellationRules($rfqCancelRuleId);
            $rfqCanRules->deleteAttachedReasons();
        }
        
        $record = new RfqCancellationRules($rfqCancelRuleId);
        $record->assignValues($data);
        if (!$record->save()) {
            Message::addErrorMessage($record->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        
        $rfqCancelRuleId = $record->getMainTableRecordId();
        
        foreach($postedData['rule_reasons'] as $ruleReason) {
            $dataToSave = array(
                'reasontorule_rule_id' => $rfqCancelRuleId,
                'reasontorule_reason_id' => $ruleReason,
            );
            
            $record = new TableRecord(RfqCancellationRules::DB_TBL_REASON_TO_RULE);
            $record->assignValues($dataToSave);
            if (!$record->addNew(array(), $dataToSave)) {
                Message::addErrorMessage($record->getError());
                FatUtility::dieJsonError(Message::getHtml());
            }
        }
        
        Message::addMessage(Labels::getLabel('MSG_Cancel_Rule_Setup_Successfully.', $this->adminLangId));
        FatUtility::dieJsonSuccess(Message::getHtml());
    }
    
    public function changeStatus()
    {
        $this->objPrivilege->canEditRfqCancellationRules();
        $ruleId = FatApp::getPostedData('ruleId', FatUtility::VAR_INT, 0);
        $status = FatApp::getPostedData('status', FatUtility::VAR_INT, 0);
        
        if (0 >= $ruleId) {
            Message::addErrorMessage($this->str_invalid_request_id);
            FatUtility::dieWithError(Message::getHtml());
        }

        $obj = new RfqCancellationRules($ruleId);
        if (!$obj->changeStatus($status)) {
            Message::addErrorMessage($obj->getError());
            FatUtility::dieWithError(Message::getHtml());
        }
        
        $this->set('msg', $this->str_update_record);
        $this->_template->render(false, false, 'json-success.php');
    }
    
}
